/********************************************************
 * Cool about Box for my programs
 *
 *  Darryll Sulymka
 */

/*** Include *****************************************************************/ 
#include <windows.h>
#include <stdlib.h>

#include "about.h"

/*** Defines *****************************************************************/ 
#define STARFIELD   0

#define STARNUM     30
/*** Globles *****************************************************************/ 
char Title[] = "Puzzel V1.3b Copyright 2003 by Darryll Sulymka";
char BugEmail[] = "dsulymka@hotmail.com";
char HomePage[] = "http://members.shaw.ca/dsulymka/";
char LicencesInfo[] = "This Program is freeware";
char DevelopmentTeam[] = "Programer: Darryll Sulymka\n  Art Work: Darryll Sulymka\n      Tester: Darryll Sulymka";

int ABOUT_WIDTH  = 512;
int ABOUT_HEIGHT = 240;
int AboutWindowReady = 0;   //about Init was called before
int Kill_Thread = 1;        //Flag for the thread to exit
int BackgroundType = STARFIELD;
POINT3D stars[STARNUM];
char ClsNm[ ] = "AboutBox"; //Class Name
HWND AboutBox;              //Handle to the window.

HANDLE ThreadCAB;
DWORD ThreadCABID;

/*** CoolAboutBox Draws the about box ****************************************/
DWORD WINAPI CoolAboutBox( LPVOID ){
   int i,x,y;
   RECT textRect;
   HDC hdcbuffer,hdc = GetDC(AboutBox);
   char temp[80];
   HBITMAP buffer;
   HFONT NewFont,OldFont;
   
   //////////  Init //////////
   buffer = CreateCompatibleBitmap(hdc,ABOUT_WIDTH,ABOUT_HEIGHT);
   hdcbuffer = CreateCompatibleDC(hdc);
   SelectObject(hdcbuffer,buffer); 
   NewFont = CreateFont(20,0,0,0,400,0,0,0,ANSI_CHARSET,OUT_CHARACTER_PRECIS,
               CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,FF_DONTCARE|DEFAULT_PITCH,"Arial");
   if (NewFont!=NULL){
      OldFont = (HFONT)SelectObject(hdcbuffer,NewFont);
   }
   SetTextColor(hdcbuffer,RGB(190,190,240));
   SetBkMode(hdcbuffer,TRANSPARENT);
      
   srand(5);
   textRect.left = ABOUT_WIDTH/2;
   textRect.right = ABOUT_WIDTH/2;
   textRect.top = 62;
   textRect.bottom = ABOUT_HEIGHT-162;
   switch (BackgroundType){
          case STARFIELD:
            for (i=0;i<STARNUM;i++){
               do{
                 stars[i].x= rand()%(ABOUT_WIDTH+1) - ABOUT_WIDTH/2;
                 stars[i].y= rand()%(ABOUT_HEIGHT+1) - ABOUT_HEIGHT/2;
               }while((stars[i].x==0)&&(stars[i].y==0));
                stars[i].z=(double)(i+1)/3.0;
            }
            break;
   }
   
   //////////  Run time Loop //////////
   while(!Kill_Thread){
     Sleep(20);
     BitBlt(hdcbuffer,0,0,ABOUT_WIDTH,ABOUT_HEIGHT,NULL,0,0,BLACKNESS);
     switch (BackgroundType){
          case STARFIELD:
             for(i=0;i<STARNUM;i++){
                BitBlt(hdcbuffer,(int)(stars[i].x/stars[i].z+(ABOUT_WIDTH/2)),
                    (int)(stars[i].y/stars[i].z+(ABOUT_HEIGHT/2)),
                    1,1,NULL,0,0,WHITENESS);
                stars[i].z-=0.10;
                if (stars[i].z<=0)
                    stars[i].z=10;
             }
             break;
     }
     SetTextAlign(hdcbuffer,TA_CENTER);
     TextOut(hdcbuffer,ABOUT_WIDTH/2,2,Title,strlen(Title));
     TextOut(hdcbuffer,ABOUT_WIDTH/2,40,"Development Team",16);
     DrawText(hdcbuffer,DevelopmentTeam,-1,&textRect,DT_NOCLIP	);
     SetTextAlign(hdcbuffer,TA_LEFT);
     wsprintf(temp,"Send Comments / Requests / Bugs to %s",BugEmail);
     TextOut(hdcbuffer,2,ABOUT_HEIGHT-60,temp,strlen(temp));
     wsprintf(temp,"Visit our Homepage at %s",HomePage);
     TextOut(hdcbuffer,2,ABOUT_HEIGHT-40,temp,strlen(temp));
     TextOut(hdcbuffer,2,ABOUT_HEIGHT-20,LicencesInfo,strlen(LicencesInfo));
     BitBlt(hdc,0,0,ABOUT_WIDTH,ABOUT_HEIGHT,hdcbuffer,0,0,SRCCOPY);

   }
   if (NewFont!=NULL){
      SelectObject(hdcbuffer,OldFont);
   }
   DeleteObject(NewFont);
	DeleteObject(buffer);
	DeleteObject(hdcbuffer);
   ReleaseDC(AboutBox,hdc);
   ExitThread(1);
}

/*** WinProc for About Window ************************************************/
LRESULT CALLBACK WinProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    
    switch (message)                  /* handle the messages */
    {
        case WM_DESTROY:
            Kill_Thread=1;
            Sleep(10);
            CloseHandle(ThreadCAB);
            PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
            break;
        case WM_LBUTTONUP:
            ShowWindow(hwnd,SW_HIDE);
            Kill_Thread = 1;
            break;
        case WM_PAINT:
            break;
        default:                      /* for messages that we don't deal with */
            return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}

/*** about() Shows window ****************************************************/
int about(){
   int i=0;
   if (AboutWindowReady){
      
      ShowWindow(AboutBox,SW_SHOWNORMAL);
      CloseHandle(ThreadCAB);
      if(Kill_Thread==1){
        Kill_Thread=0;
        ThreadCAB =  CreateThread(NULL,0,CoolAboutBox,NULL,0,&ThreadCABID);
      }
   }
   else{
      MessageBox(NULL,"Can't Create Window","Bad Error",0);
      return 0;
   }
   return 1;
}

/*** aboutInit() Inilizeds the window ****************************************/
int aboutInit(HINSTANCE hInst,HWND ParentWND){
   WNDCLASS wcAbout;
   
   if (!AboutWindowReady){
       wcAbout.style = CS_DBLCLKS;
       wcAbout.lpfnWndProc = WinProc;
       wcAbout.cbClsExtra = 0;
       wcAbout.cbWndExtra = 0;
       wcAbout.hInstance = hInst;
       wcAbout.hIcon = NULL;
       wcAbout.hCursor = LoadCursor (NULL, IDC_ARROW);
       wcAbout.hbrBackground = (HBRUSH) COLOR_BACKGROUND;
       wcAbout.lpszMenuName = NULL;
       wcAbout.lpszClassName = ClsNm;
       
       if (!RegisterClass (&wcAbout))
           return 0;

       AboutBox = CreateWindow(ClsNm,"",WS_POPUP, 
                     GetSystemMetrics(SM_CXSCREEN)/2-(ABOUT_WIDTH/2),
                     GetSystemMetrics(SM_CYSCREEN)/2-(ABOUT_HEIGHT/2),
                     ABOUT_WIDTH,ABOUT_HEIGHT,ParentWND,NULL,hInst,NULL);
       AboutWindowReady++;
   }

   return 1;
} 

