#include <windows.h>
#include <mmsystem.h>
#include <time.h>
#include "about.h"

#define IDM_SYS_ABOUT   1
#define IDM_SYS_NUMBER  2
#define IDM_SYS_RESTORE 3
#define IDM_SYS_CLIP    4


//#pragma comment(lib,"WINMM.LIB")

#include "resource.h"


LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);
int Setup_Window();
int Numbers();
int RestorePic();
int PaintWindow(HWND hwnd, HDC hdc);
int Line(int x, int y, int x2, int y2, HDC hdc);
int CheckMove(int x,int y);

int Puzzle[4][4];
int win;
int CloseColor;
int MinColor;
HWND hwnd;
WNDCLASS wndclass ;
HINSTANCE hInstanceG;
HBITMAP PuzzleBitmap;
TCHAR szAppName[] = TEXT ("Puzzle") ;

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow){
	int i,j,t=0;
	HMENU hmenu;

	MSG msg ;

	hInstanceG = hInstance;

	srand(time(0));
	for (i=0;i<4;i++)
		for(j=0;j<4;j++){
			Puzzle[i][j]=t;
			t++;
		}

	for(i=0;i<50000;i++){
		CheckMove((int) ( ((double)rand()/RAND_MAX) *4),(int) ( ((double)rand()/RAND_MAX) *4));
	}
	win=0;
	CloseColor=0;
	MinColor=0;

	if(!Setup_Window()){
		return 0;
	}
	PuzzleBitmap = LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_DEFAULT_PUZZLE));
	aboutInit(hInstance,hwnd);
	hmenu = GetSystemMenu (hwnd, FALSE);
	
	AppendMenu (hmenu, MF_SEPARATOR, 0, NULL);
   AppendMenu (hmenu, MF_STRING, IDM_SYS_NUMBER, TEXT ("Change to Numbers"));
   AppendMenu (hmenu, MF_STRING, IDM_SYS_RESTORE, TEXT ("Restore Picture"));
   AppendMenu (hmenu, MF_STRING, IDM_SYS_CLIP, TEXT ("Paste From Clipboard"));
	AppendMenu (hmenu, MF_STRING, IDM_SYS_ABOUT, TEXT ("About..."));
	
	ShowWindow (hwnd, iCmdShow) ;
	UpdateWindow (hwnd) ;
     
	while (GetMessage (&msg, NULL, 0, 0)){
		TranslateMessage (&msg) ;
		DispatchMessage (&msg) ;
	}

	DeleteObject (PuzzleBitmap);

	return msg.wParam ;
}

LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	static int MoveWindow = 0;
	static int x,y,clo=0,min=0;
	int xtemp,ytemp,i,j,t;
	HDC hdc,hdcbuffer,hdcbitmap;
	HBITMAP buffer;
	BITMAP bitmap;
	PAINTSTRUCT ps;
	WINDOWPLACEMENT winLoc;
	RECT rect;
	


	switch (message){
		case WM_CREATE:
			return 0;

		case WM_PAINT:
			hdc = BeginPaint (hwnd, &ps);
			GetClientRect (hwnd, &rect);
			buffer = CreateCompatibleBitmap(hdc,rect.right,rect.bottom);
			hdcbuffer = CreateCompatibleDC(hdc);
			SelectObject(hdcbuffer,buffer);
			PaintWindow(hwnd, hdcbuffer);
			BitBlt(hdc,0,0,rect.right+1,rect.bottom+1,hdcbuffer,0,0,SRCCOPY);
			DeleteObject(buffer);
			DeleteObject(hdcbuffer);
			EndPaint (hwnd, &ps);
			return 0;
		case WM_LBUTTONDOWN:
			GetClientRect (hwnd, &rect);
			x = (short)LOWORD(lParam);
			y = (short)HIWORD(lParam);
			if (!win){
				if(CheckMove((x)/50,(y)/38)){
					t=0;
					for (i=0;i<4;i++)
						for(j=0;j<4;j++){
							if (Puzzle[i][j]==t)
							t++;
						}
	
					if (t==16){
						win=1;
						//PlaySound(MAKEINTRESOURCE(IDR_WIN), hInstanceG, SND_ASYNC | SND_RESOURCE);
					}
					else;
						//PlaySound(MAKEINTRESOURCE(IDR_SHIFT), hInstanceG, SND_ASYNC | SND_RESOURCE);

					InvalidateRect (hwnd, NULL, FALSE);
					
				}
			}
			return 0;
		case WM_LBUTTONDBLCLK:
			x = (short)LOWORD(lParam);
			y = (short)HIWORD(lParam);
			if (win==1){
				for(i=0;i<50000;i++){
					CheckMove((int) ( ((double)rand()/RAND_MAX) *4),(int) ( ((double)rand()/RAND_MAX) *4));
				}
				win=0;
				InvalidateRect (hwnd, NULL, FALSE);
			}
			return 0;

		case WM_LBUTTONUP:
			MoveWindow = 0;
			return 0;
		
		case WM_MOUSEMOVE:
			return 0;
		case WM_SYSCOMMAND:
		  switch(LOWORD(wParam)){
		      case IDM_SYS_NUMBER:
               Numbers();
               InvalidateRect (hwnd, NULL, FALSE);
		         return 0;
            case IDM_SYS_RESTORE:
               RestorePic();
               InvalidateRect (hwnd, NULL, FALSE);
               return 0;
            case IDM_SYS_CLIP:
               if(IsClipboardFormatAvailable(CF_BITMAP)){
                  OpenClipboard(hwnd);
				      buffer = (HBITMAP) GetClipboardData (CF_BITMAP);
				      if (buffer==NULL);
				      hdc = GetDC(hwnd);
				      hdcbitmap = CreateCompatibleDC(hdc);
				      hdcbuffer = CreateCompatibleDC(hdc);
				      SelectObject(hdcbitmap,buffer);
				      SelectObject(hdcbuffer,PuzzleBitmap);
				
    				   if(GetObject(buffer,sizeof(BITMAP),&bitmap));

     				   SetStretchBltMode(hdcbuffer,HALFTONE);
     				   if(StretchBlt(hdcbuffer,0,0,200,150,hdcbitmap,0,0,bitmap.bmWidth,bitmap.bmHeight,SRCCOPY));

     				   
     				   DeleteObject(hdc);
     				   DeleteObject(hdcbuffer);
     				   DeleteObject(hdcbitmap);
     				   CloseClipboard();
     				   InvalidateRect (hwnd, NULL, FALSE);
     				}
               return 0;
		      case IDM_SYS_ABOUT:
               about();
               return 0;
		  }
		  break;
		case WM_COMMAND:
			if (!HIWORD(wParam)){
				switch(LOWORD(wParam)){
				case 61472: // Minimize
					CloseWindow(hwnd);
					break;
				case 61536: //Close
					break;
				default:
					break;
				}
			}
			return 0;
		case WM_DESTROY:
			PostQuitMessage (0);
			return 0;
	}

	return DefWindowProc (hwnd, message, wParam, lParam) ;
}

int Numbers(){
   HDC hdc,temp;
   HFONT NewFont,OldFont;
   int i,x=25,y=5;
   char buff[4];
   hdc = GetDC(hwnd);
   
  	temp = CreateCompatibleDC(hdc);
	SelectObject(temp, PuzzleBitmap);
	SetTextAlign(temp,TA_CENTER);
	
	NewFont = CreateFont(35,0,0,0,700,0,0,0,ANSI_CHARSET,OUT_CHARACTER_PRECIS,
               CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,FF_DONTCARE|DEFAULT_PITCH,"Arial");
   OldFont = (HFONT)SelectObject(temp,NewFont);
   
	BitBlt(temp,0,0,200,150,NULL,0,0,WHITENESS);
	
   for(i=1;i<16;i++){
      wsprintf(buff,"%d",i);
      TextOut(temp,x,y,buff,strlen(buff));
      x+=50;
      if (x>178){
         x=25;
         y+=37;
      }
   }
   TextOut(temp,x,y,"W",1);
   SelectObject(temp,OldFont);
   DeleteObject(NewFont);
	ReleaseDC(hwnd,hdc);
   DeleteDC(temp);
   return 1;
}

int RestorePic(){
   DeleteObject (PuzzleBitmap);
   PuzzleBitmap = LoadBitmap(hInstanceG,MAKEINTRESOURCE(IDB_DEFAULT_PUZZLE));
   return 1;
}

int CheckMove(int x,int y){
	int i;
	if((x>3)||(y>3)||(x<0)||(y<0))
		return 0;

	if(Puzzle[x][y]==15)
		return 0;

	if(x<3){
		i = x;
		while(i<3){
			i++;
			if(Puzzle[y][i]==15){
				while(i!=x){
					i--;
					Puzzle[y][i+1] = Puzzle[y][i];
				}
				Puzzle[y][x] = 15;
				return 1;
			}
		}
	}
	if(y<3){
		i = y;
		while(i<3){
			i++;
			if(Puzzle[i][x]==15){
				while(i!=y){
					i--;
					Puzzle[i+1][x] = Puzzle[i][x];
				}
				Puzzle[y][x] = 15;
				return 1;
			}
		}
	}

	if(x>0){
		i = x;
		while(i>0){
			i--;
			if(Puzzle[y][i]==15){
				while(i!=x){
					i++;
					Puzzle[y][i-1] = Puzzle[y][i];
				}
				Puzzle[y][x] = 15;
				return 1;
			}
		}
	}

	if(y>0){
		i = y;
		while(i>0){
			i--;
			if(Puzzle[i][x]==15){
				while(i!=y){
					i++;
					Puzzle[i-1][x] = Puzzle[i][x];
				}
				Puzzle[y][x] = 15;
				return 1;
			}
		}
	}

	return 0;
}

int Line(int x, int y, int x2, int y2, HDC hdc){
	MoveToEx(hdc,x,y,NULL);
	LineTo(hdc,x2,y2);
	return 1;
}

int PaintWindow(HWND hwnd, HDC hdc){
	RECT rect;
	HBRUSH BackColor;
	HPEN CurrentPen, tempPen;
	HDC temp;
	int i,j,t,puzz;
	
	temp = CreateCompatibleDC(hdc);

	//Puzzle
	SelectObject(temp, PuzzleBitmap);
	CurrentPen = CreatePen(PS_SOLID,0,RGB(0,0,0));
	tempPen = (HPEN)SelectObject(hdc, CurrentPen);

	if (win){
		BitBlt(hdc,0,0,200,150,temp,0,0,SRCCOPY);
	}
	else {
		t=0;
		for(j=0;j<4;j++){
			for(i=0;i<4;i++){
				puzz = Puzzle[j][i];
				if(puzz!=15)
					BitBlt(hdc,50*i,t,50,37,temp,0+((puzz%4)*50),0+((puzz/4)*37),SRCCOPY);
				else
					BitBlt(hdc,50*i,t,50,37,temp,0+((puzz%4)*50),0+((puzz/4)*37),BLACKNESS);
			}
			if(j>1)
				t+=38;
			else
				t+=37;
		}
		for(i=0;i<4;i++){
			Line(50*i,0,50*i,150,hdc);
		}
		Line(0,37,200,37,hdc);
		Line(0,74,200,74,hdc);
		Line(0,111,200,111,hdc);
		Line(0,151,200,151,hdc);
	}

	SelectObject(hdc, tempPen);
	DeleteObject(CurrentPen);
	DeleteDC(temp);
	return 1;
}

int Setup_Window(){
	wndclass.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc   = WndProc ;
	wndclass.cbClsExtra    = 0 ;
	wndclass.cbWndExtra    = 0 ;
	wndclass.hInstance     = hInstanceG ;
	wndclass.hIcon         = LoadIcon (hInstanceG, MAKEINTRESOURCE(IDI_PUZZLE));
	wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
	wndclass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH) ;
	wndclass.lpszMenuName  = NULL ;
	wndclass.lpszClassName = szAppName ;

	if (!RegisterClass (&wndclass)){
		MessageBox (NULL, TEXT ("This program refuses to work on this computer"), 
					szAppName, MB_ICONERROR) ;
		return 0 ;
	}

	hwnd = CreateWindow (szAppName,					// window class name
			TEXT ("Puzzle"),						// window caption
			WS_POPUP | WS_VISIBLE | WS_SYSMENU |WS_MINIMIZEBOX |WS_CAPTION	 ,	// window style
			200,									// initial x position
			200,									// initial y position
			207,									// initial x size
			176,									// initial y size
			NULL,									// parent window handle
			NULL,									// window menu handle
			hInstanceG,								// program instance handle
			NULL);									// creation parameters
	return 1;
}

