/* debug.h
 *
 *	Win32 doesn't give us a console to printf any debugging information. This
 *	makes Linux hackers very sad   :(
 *	
 *	However, we can attach a pseudo-console to our application and print to
 *	that. These routines provide that functionality. Since we do use stdio
 *	within the program in various places, we're calling our output function
 *	"dprintf" - debug printf. This makes Linux hackers very happy   :)
 */
#ifndef COMMAUDIO_DEBUG_H
#define COMMAUDIO_DEBUG_H

/*
 * init_debug
 *	Initialize the debugging console. Just call it at the beginning
 *	of the program and the console window will appear.
 *
 * Parameters: NONE
 *
 * Return: NONE
 */
void init_debug(void);

/*
 * stop_debug
 *	De-allocates debugging console. Probably not strictly necessary
 *	as it will go away upon exit, but we don't want to put too much
 *	faith in Windows to take care of getting rid of our stuff. Call
 *	it on exit.
 *
 * Parameters: NONE
 *
 * Return: NONE
 */
void stop_debug(void);

/*
 * dprintf
 *	Prints to the debugging console.
 *
 *	Follows exactly the same semantics as printf, so
 *	I won't explain it any further here
 */
void dprintf( const char *format, ... );

#endif
