// TetrisDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Tetris.h"
#include "TetrisDlg.h"
#include "TetrisAI.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define SQ_WIDTH		15
#define BOARDER			10
#define IDT_GAMEUPDATE	1
#define IDT_AIUPDATE	2

/////////////////////////////////////////////////////////////////////////////
// CTetrisDlg dialog

CTetrisDlg::CTetrisDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTetrisDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTetrisDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_Back.LoadBitmap (IDB_BACK);
	m_Blocks.LoadBitmap (IDB_BLOCKS);
}

void CTetrisDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTetrisDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTetrisDlg, CDialog)
	//{{AFX_MSG_MAP(CTetrisDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_SIZE()
	ON_WM_CREATE()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTetrisDlg message handlers

BOOL CTetrisDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTetrisDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	DrawBoard(&dc);


	if (IsIconic())
	{
	//	CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTetrisDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTetrisDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	
}

int CTetrisDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	int i,j;
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	srand(5);
	//Init Data
	for(i=0;i<10;i++)
		for(j=0;j<22;j++)
			board [i][j] = 0;
	
	NextPiece();
	NextPiece();

	//Start Timmers
	this->SetTimer (IDT_GAMEUPDATE,20,NULL);
	this->SetTimer (IDT_AIUPDATE,20,NULL);
	initAI();
	thinkAI(board, &currentPiece);	
	return 0;
}

void CTetrisDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	CDC *dc;
	dc = GetDC ();
	switch(nIDEvent){
		case IDT_GAMEUPDATE:
			if(Update()){/*Game Over man*/
				KillTimer (IDT_GAMEUPDATE);
				KillTimer (IDT_AIUPDATE);
			}
			DrawBoard(dc);
			break;
		case IDT_AIUPDATE:
			switch (makeMoveAI(&currentPiece)){
				case AI_NO_MOVE:
					//no move
					break;
				case AI_LEFT:
						left();
						DrawBoard(dc);
					break;
				case AI_RIGHT:
					right();
					DrawBoard(dc);
					break;
				case AI_ROTATE:
					RotatePiece();
					DrawBoard(dc);
					break;
			}
			break;
	}
	ReleaseDC(dc);
	CDialog::OnTimer(nIDEvent);
}

void CTetrisDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	cleanUpAI();
	// TODO: Add your message handler code here
	this->KillTimer (1);	
}

void CTetrisDlg::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	CDC *dc;
	dc = GetDC ();
	switch(nChar){
		case VK_NUMPAD4:
			left();
			DrawBoard(dc);
			break;
		case VK_NUMPAD6:
			right();
			DrawBoard(dc);
			break;
		case VK_NUMPAD2:
			Update();
			DrawBoard(dc);
			break;
		case VK_NUMPAD5:
		case VK_NUMPAD8:
			RotatePiece();
			DrawBoard(dc);
			break;
	}
	ReleaseDC(dc);
	CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CTetrisDlg::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CTetrisDlg::DrawBoard(CDC *dc)
{
	CDC hdcMem;
	CDC hdcMem1;
	CDC hdcMem2;
	CBitmap buffer;
	CRect rect;
	BITMAP bitmap;
	int x,y;
	int tboard [10] [22];
	GetClientRect (rect);
	buffer.CreateCompatibleBitmap (dc,rect.Width (),rect.Height ());
	hdcMem2.CreateCompatibleDC(NULL);
	hdcMem2.SelectObject(&buffer);
	hdcMem1.CreateCompatibleDC(NULL);
	hdcMem1.SelectObject(&m_Blocks);
	hdcMem.CreateCompatibleDC(NULL);
	hdcMem.SelectObject(&m_Back);
	
	m_Back.GetBitmap (&bitmap);

	hdcMem2.BitBlt (0,0,bitmap.bmWidth, bitmap.bmHeight , &hdcMem,0,0,SRCCOPY);

	for (x=0;x<10;x++)
		for (y=0;y<22;y++)
			tboard[x][y]=board[x][y];

	for (x=0;x<4;x++)
		for (y=0;y<4;y++)
			if ((currentPiece.x+x<10)&&(currentPiece.y+y<22)&&(currentPiece.piece[x][y]!=0))
				tboard[x+currentPiece.x][y+currentPiece.y]=currentPiece.piece[x][y];


	for(y=19;y>=0;y--)
		for(x=0;x<10;x++){
			if (tboard[x][y+2]!=0)
				hdcMem2.BitBlt (x*SQ_WIDTH+BOARDER,y*SQ_WIDTH+BOARDER,SQ_WIDTH-1,SQ_WIDTH,
					&hdcMem1,0+(SQ_WIDTH)*(tboard[x][y+2] - 2),0,SRCCOPY);
			else
				hdcMem2.FillSolidRect (x*SQ_WIDTH+BOARDER,y*SQ_WIDTH+BOARDER,
					SQ_WIDTH,SQ_WIDTH,RGB(0,0,0));

		}
	dc->BitBlt (0,0,rect.Width (),rect.Height (),&hdcMem2,0,0,SRCCOPY);
}

void CTetrisDlg::NextPiece()
{
	int x,y,i,j,temp;

	currentPiece=nextPiece;

	for (x=0;x<4;x++)
		for (y=0;y<4;y++)
			nextPiece.piece[x][y]=0;
    temp = rand()%7+1;
	temp = 5;
	switch (temp){
		case 1:     //line
			for (x=0;x<4;x++)
				nextPiece.piece[x][1]=2;
			nextPiece.type = 1;
			break;
		case 2:       //L
			for (x=1;x<4;x++)
				nextPiece.piece[x][2]=3;
			nextPiece.piece[1][1]=3;
			nextPiece.type = 2;
			break;
		case 3:       //BL
			for (x=1;x<4;x++)
				nextPiece.piece[x][2]=4;
			nextPiece.piece[2][1]=4;
			nextPiece.type = 2;
			break;
		case 4:      //T
			for (x=1;x<4;x++)
				nextPiece.piece[x][2]=5;
			nextPiece.piece[3][1]=5;
			nextPiece.type = 2;
			break;
		case 5:  // Square
			for (i=1;i<3;i++)
				for (j=1;j<3;j++)
					nextPiece.piece[i][j]=6;
				nextPiece.type = 3;
		break;
		case 6: // z
			for (i=0;i<2;i++){
				nextPiece.piece[i][1]=7;
				nextPiece.piece[i+1][2]=7;
			}
			nextPiece.type = 1;
		break;
		case 7:// s
			for (i=0;i<2;i++){
				nextPiece.piece[i+1][1]=8;
				nextPiece.piece[i][2]=8;
			}
			nextPiece.type = 1;
		break;
	}
	currentPiece.x=3;
	currentPiece.y=0;
}

int CTetrisDlg::Update()
{
	int x,y,i,change_all=0,game_over=0,loop=1,line=0;
	int tboard [10] [22];

	for (x=0;x<10;x++)
		for (y=0;y<22;y++)
			tboard[x][y]=board[x][y];

	for (x=0;x<4;x++)
		for (y=0;y<4;y++)
			if((currentPiece.piece[x][y]!=0)&&(currentPiece.y+y==21))
				change_all=1;

	if (change_all!=1)
		for (x=0;x<4;x++)
			for (y=0;y<4;y++)
				if ((currentPiece.x+x<10)&&(currentPiece.y+y+1<22)&&(currentPiece.piece[x][y]!=0))
					if (tboard[x+currentPiece.x][y+currentPiece.y+1]!=0)
						change_all=1;

	if (change_all==1){
		for (x=0;x<4;x++)
			for (y=0;y<4;y++)
				if ((currentPiece.x+x<10)&&(currentPiece.y+y>=0)&&(currentPiece.piece[x][y]!=0))
					tboard[x+currentPiece.x][y+currentPiece.y]=currentPiece.piece[x][y];

		for (x=0;x<10;x++)
			for (y=0;y<22;y++)
				board[x][y] = tboard[x][y];
		NextPiece();
   }

	for (x=0;x<10;x++)
		for (y=0;y<3;y++)
			if (tboard[x][y]!=0)
				game_over=1;

	y=21;

	if ((change_all==1)&&(game_over!=1))
		while(loop){
			if ((board[0][y]!=0)&&(board[1][y]!=0)&&(board[2][y]!=0)&&(board[3][y]!=0))
				if ((board[4][y]!=0)&&(board[5][y]!=0)&&(board[6][y]!=0)&&(board[7][y]!=0))
					if ((board[8][y]!=0)&&(board[9][y]!=0)){
						for (x=0;x<10;x++)
							for (i=y-1;i>0;i--){
								board[x][i+1]=board[x][i];
								board[x][i]=0;
							}
							y++;
							line++;
					}
			y--;
			if (y==0)
				loop=0;
		}

	if(change_all==0)
		currentPiece.y++;
	else
		thinkAI(board, &currentPiece);

	return game_over;
}

void CTetrisDlg::left()
{
	int x,y,can_move=1;
	int tboard [10] [22];

	for (x=0;x<10;x++)
		for (y=0;y<22;y++)
			tboard [x][y] = board [x][y];
	for (x=0;x<4;x++)
		for (y=0;y<4;y++)
			if ((currentPiece.x+x<10)&&(currentPiece.y+y<22)&&(currentPiece.piece[x][y]))
				tboard[x+currentPiece.x][y+currentPiece.y]=1;

	for (y=0;y<22;y++)
		if (tboard[0][y]==1)
			can_move=0;

	for (x=1;x<10;x++)
		for (y=0;y<22;y++)
			if ((tboard[x][y]==1)&&(tboard[x-1][y]>1))
				can_move=0;

	if (can_move==1)
		currentPiece.x--;
}


void CTetrisDlg::right()
{
	int x,y,can_move=1;
	int tboard [10] [22];

	for (x=0;x<10;x++)
		for (y=0;y<22;y++)
			tboard [x][y] = board [x][y];

	for (x=0;x<4;x++)
		for (y=0;y<4;y++)
			if ((currentPiece.x+x<10)&&(currentPiece.y+y<22)&&(currentPiece.piece[x][y]))
				tboard[x+currentPiece.x][y+currentPiece.y]=1;

	for (y=0;y<22;y++)
		if (tboard[9][y]==1)
			can_move=0;

	for (x=0;x<9;x++)
		for (y=0;y<22;y++)
			if ((tboard[x][y]==1)&&(tboard[x+1][y]>1))
				can_move=0;

	if (can_move==1)
		currentPiece.x++;
}

void CTetrisDlg::RotatePiece()
{
	int x,y,dir=1,can_rotate=1;
	char temp [4][4];

	for(x=0;x<4;x++)
		for(y=0;y<4;y++)
			temp[x][y] = 0;

	switch(currentPiece.type) {
		case 1:
			if (dir==1) {
				for(x=0;x<4;x++)
					for(y=0;y<4;y++)
						temp[y][3-x] = currentPiece.piece[x][y];
			}
			else if (dir==2) {
				for(x=0;x<4;x++)
					for(y=0;y<4;y++)
						temp[3-y][x] = currentPiece.piece[x][y];
			}
			break;
		case 2:
			if (dir==1) {
				for(x=1;x<4;x++)
					for(y=0;y<3;y++)
						temp[y+1][3-x] = currentPiece.piece[x][y];
			}
			else if (dir==2) {
				for(x=1;x<4;x++)
					for(y=0;y<3;y++)
						temp[3-y][x-1] = currentPiece.piece[x][y];
			}
			break;
		case 3:
			can_rotate=0;
			break;
	}

	for(x=0;x<4;x++)
		for(y=0;y<4;y++)
			if (temp[x][y]!=0)
				if((x+currentPiece.x<0)||(x+currentPiece.x>9)||(y+currentPiece.y>21)||
					(board[x+currentPiece.x][y+currentPiece.y]!=0))
					can_rotate=0;
	if (can_rotate==1){
		for(x=0;x<4;x++)
			for(y=0;y<4;y++)
				currentPiece.piece[x][y] = temp[x][y];

	}
}


