#include "stdafx.h"
#include "TetrisAI.h"
#include "debug.h"

static int x;
//Returns 1 on Success
int initAI(){
	init_debug();
	dprintf("AI Initialized\n");
	return 1;
}

int cleanUpAI(){
	stop_debug();
	return 1;
}

void thinkAI(int board[10][22], PIECE *current) {
	int currentHeight,hit,i,j,k;
	int oldscore=0;
	int wLow,wHigh;
	int temp;
	int a;

	/*** The AI will start be getting some basic info **********/
	hit = 0;
	for (i=0;i<22;i++){
		for (j=0;j<10;j++){
			if(board[j][i]!=0){
				hit=1;
				break;
			}
		}
		if(hit){
			currentHeight = i;
			break;
		}
	}
	if (hit == 0)
		currentHeight = 21;

	/*** Checking all piece placment spots ***********************/
	//will need to run threw all Rotations
	hit=0;
	for(i=0;i<4;i++){
		for(j=0;j<4;j++){
			if(current->piece[i][j]!=0){
				hit = 1;
				break;
			}
		}
		if(hit){
			wLow = i;
			break;
		}
	}
	hit=0;
	for(i=3;i>=0;i--){
		for(j=0;j<4;j++){
			if(current->piece[i][j]!=0){
				hit = 1;
				break;
			}
		}
		if(hit){
			wHigh = i;
			break;
		}
	}
	temp = 10 - wHigh + wLow;
	for(i=0;i<temp;i++){
		a = 0;
		for(j=0;j<11-temp;j++){
			for(k=currentHeight;k<22;k++){
				if(board[i+j][k]!=0)
					break;
			}
			a += k;
		}
		if (a > oldscore){
			x = i;
			oldscore = a;
		}
	}
	/*** Finnal desidion made ************************************/
	dprintf("\nthinkAI x = %d, wLow = %d, wHigh = %d, temp = %d\n",x,wLow,wHigh,temp);
}

int makeMoveAI(PIECE *current){
//	dprintf("\nmakeMoveAI Begining\n",x);
	int tx,i,j,hit=0;

	/*** Detimaning if need to move lefto or right ********************/
	for (i=0;i<4;i++){
		for (j=0; j<4; j++){
			if(current->piece[i][j]!=0){
				hit=1;
				break;
			}
		}
		if (hit){
			tx = current->x + i;
			break;
		}
	}
	
	if(tx > x){
//		dprintf("AI Move = AI_LEFT\n");
		return AI_LEFT;
	}
	else if (tx < x){
//		dprintf("AI Move = AI_RIGHT\n");
		return AI_RIGHT;

	}

	/*** No shift or rotation is need ********************************/
//	dprintf("AI Move = AI_NO_MOVE\n");
	return AI_NO_MOVE;
}

int minofpos(int a,int b,int c,int d){
	int temp;

	if (a < b)
		temp = a;
	else
		temp = b;

	if (c < temp)
		temp = c;

	if (d < temp)
		temp = d;

	return temp;
}