//Darryll Sulymka
/*** This program is a text based tetris.  This will be the base for a
	Graphical tetris ***/
/*** Includes **********************************************************/
#include <conio.h>
#include <stdlib.h>
#include "allegro.h"
/*** Allegro Driver Used ***********************************************/

BEGIN_DIGI_DRIVER_LIST
 DIGI_DRIVER_SB
END_DIGI_DRIVER_LIST

BEGIN_MIDI_DRIVER_LIST
  MIDI_DRIVER_ADLIB
  MIDI_DRIVER_SB_OUT
END_MIDI_DRIVER_LIST

/*** Structs ***********************************************************/
struct piece {
	char piece[4][4],type;
	int x,y; };

/*** Globals ***********************************************************/
struct piece current, next;
char board[10][22];
int song=1,score,lines,nextlines;
MIDI *the_music;
volatile int time_test = 0;
SAMPLE *That_all;
SAMPLE *Line_Sound1;
SAMPLE *Line_Sound2;
SAMPLE *Line_Sound3;
SAMPLE *Line_Sound4;

/*** timer interrupt handler ******************************************/
void inc_time_test()
{time_test++;}
END_OF_FUNCTION(inc_time_test);

/*** Setup ************************************************************/
void menu();
void credits();
void music_next();
void game(int level);
void disp_setup(int level);
void menu_disp();
void nextpiece();
void draw_board(int level);
int update(int level);
void left(int level);
void right(int level);
void rotate_piece(int level);
void disp_next();

/*** Functions *********************************************************/
int main()
{  char temp;
   int loop=1;
   _setcursortype(0);
   allegro_init();
   install_keyboard();
   install_timer();
   LOCK_VARIABLE(time_test);
   LOCK_FUNCTION(inc_time_test);
   install_int(inc_time_test, 100);
   install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, temp);
   the_music = load_midi("song1.mid");
   play_midi(the_music, TRUE);
   That_all = load_sample("gameover.wav");
   Line_Sound1 = load_sample("line1.wav");
   Line_Sound2 = load_sample("line2.wav");
   Line_Sound3 = load_sample("line3.wav");
   Line_Sound4 = load_sample("line4.wav");
   menu();
   destroy_midi(the_music);
   allegro_exit();
   gotoxy(1,11);
   _setcursortype(2);
   return 0;
}
void menu_disp(int level)
{clrscr();
textcolor(1);
cprintf("ķ\n\r");
cprintf(" Game Menu \n\r");
cprintf("Ķ\n\r");
cprintf("* Play Game\n\r");
cprintf("  Music [%d]\n\r",song);
cprintf("  Level [%d]\n\r",level);
cprintf("  Credits  \n\r");
cprintf("  Quit     \n\r");
cprintf("Ľ\n\r");
}
void credits()
{
clrscr();
textcolor(1);
cprintf("ķ\n\r");
cprintf("  Credits  \n\r");
cprintf("Ķ\n\r");
cprintf("Created By:\n\r");
cprintf(" Darryll   \n\r");
cprintf("   Sulymka \n\r");
cprintf("Ľ\n\r");
while(!key[KEY_ESC]);
}
void menu()
{
int loop=1,item=1,start_level=0;
menu_disp(start_level);
while(loop)
{  if(key[KEY_UP])
     if(item!=1)
       {item--;
       gotoxy(2,4+item);
       cprintf(" ");
       gotoxy(2,3+item);
       cprintf("*");
       while(key[KEY_UP]);}
   if(key[KEY_DOWN])
     if(item!=5)
       {item++;
       gotoxy(2,2+item);
       cprintf(" ");
       gotoxy(2,3+item);
       cprintf("*");
       while(key[KEY_DOWN]);}
   if(key[KEY_ENTER])
     {switch(item)
     {case 1: //The Game part goes here
	srand(time_test);
	game(start_level);
	menu_disp(start_level);
      break;
      case 2:
	music_next();
	gotoxy(11,5);
	cprintf("%d",song);
      break;
      case 3: //The levels
	start_level++;
	if(start_level==10)
	  start_level=0;
	gotoxy(11,6);
	cprintf("%d",start_level);
      break;
      case 4://credits
      credits();
      menu_disp(start_level);
      item=1;
      break;
      case 5:
      loop=0;
      break;
      }
      while(key[KEY_ENTER]);}
}
}

void music_next()
{
switch(song)
  {
  case 1:
    stop_midi();
    the_music = load_midi("song2.mid");
    play_midi(the_music, TRUE);
    song++;
  break;
  case 2:
    stop_midi();
    the_music = load_midi("song3.mid");
    play_midi(the_music, TRUE);
    song++;
  break;
  case 3:
    stop_midi();
    the_music = load_midi("song4.mid");
    play_midi(the_music, TRUE);
    song++;
  break;
  case 4:
    stop_midi();
    the_music = load_midi("song5.mid");
    play_midi(the_music, TRUE);
    song++;
  break;
  case 5:
    stop_midi();
    the_music = load_midi("song6.mid");
    play_midi(the_music, TRUE);
    song++;
  break;
  case 6:
    stop_midi();
    the_music = load_midi("song7.mid");
    play_midi(the_music, TRUE);
    song++;
  break;
  case 7:
    stop_midi();
    the_music = load_midi("song8.mid");
    play_midi(the_music, TRUE);
    song++;
  break;
  case 8:
    stop_midi();
    the_music = load_midi("song9.mid");
    play_midi(the_music, TRUE);
    song++;
  break;
  case 9:
    stop_midi();
    the_music = load_midi("song1.mid");
    play_midi(the_music, TRUE);
    song=1;
  break;
}
}

void game(int level)
{
int i,x=time_test,key_time[6],loop=1,temp;
lines=0;
nextlines=0;
score=0;
for(i=0;i<6;i++)
key_time[i]=time_test;
disp_setup(level);
while(loop)
{
if (key[KEY_ESC])
  loop=0;
if((key[KEY_M])&&(key_time[5]<=time_test))
  {music_next();
  key_time[5]=time_test+4;
  }
if(key[KEY_P])
  {while(key[KEY_P]);
  while(!key[KEY_P]);
  while(key[KEY_P]);
  }
if ((key[KEY_RIGHT])&&(key_time[0]<=time_test))
   {right(level);
   key_time[0]=time_test+1;
   }
else if ((key[KEY_LEFT])&&(key_time[1]<=time_test))
   {left(level);
   key_time[1]=time_test+1;
   }
else if ((key[KEY_UP])&&(key_time[2]<=time_test))
   {rotate_piece(level);
   key_time[2]=time_test+2;}
else if ((key[KEY_DOWN])&&(key_time[3]<=time_test))
   {if (update(level)==1)
       loop=0;
   key_time[2]=time_test+1;}
gotoxy(11,11);
if (x<=time_test)
 {temp=20/(level+1);
  if (update(level)==1)
    loop=0;
  if (nextlines>=10)
  {nextlines=nextlines-10;
  level++;}
  x=time_test+temp;
 }
}
gotoxy(2,7);
cprintf("Game Over!");
play_sample(That_all, 255, 128, 1000, FALSE);
while(key[KEY_ESC]);
while(!key[KEY_ESC]);
}

void disp_setup(int level)
{
int i,x,y;
clrscr();
textcolor(1);
cprintf ("ķ\n\r");
cprintf ("  Tetris   Level:%d   Score : %d           \n\r",level,score);
cprintf ("Ľ\n\r");
cprintf ("           Lines:0    \n\r");
cprintf ("          Ľ\n\r");
cprintf ("           Next \n\r");
cprintf ("                \n\r");
cprintf ("          Ľ\n\r");
cprintf ("          \n\r");
for (i=1;i<=4;i++)
cprintf ("          \n\r");
cprintf ("Ľ\n\r");

for (x=0;x<10;x++)
   for (y=0;y<22;y++)
      board [x][y] = 0;
nextpiece();
nextpiece();
disp_next();
draw_board(level);
}
void disp_next()
{
int x;
gotoxy(14,7);
for(x=0;x<4;x++)
{
if ((next.piece[x][1]==0)&&(next.piece[x][2]==0))
  cprintf(" ");
else if ((next.piece[x][2]!=0)&&(next.piece[x][1]==0))
  cprintf("");
else if ((next.piece[x][2]==0)&&(next.piece[x][1]!=0))
  cprintf("");
else if ((next.piece[x][2]!=0)&&(next.piece[x][1]!=0))
  cprintf("");
}
}
void nextpiece()
{int x,y,i,j;
current=next;
for (x=0;x<4;x++)
   for (y=0;y<4;y++)
      next.piece[x][y]=0;
switch (rand()%7+1)
  {case 1:     //line
    for (x=0;x<4;x++)
      next.piece[x][1]=2;
    next.type = 1;
  break;
  case 2:       //L
    for (x=1;x<4;x++)
      next.piece[x][2]=2;
    next.piece[1][1]=2;
    next.type = 2;
  break;
  case 3:
    for (x=1;x<4;x++)
      next.piece[x][2]=2;
    next.piece[2][1]=2;
    next.type = 2;
  break;
  case 4:
    for (x=1;x<4;x++)
      next.piece[x][2]=2;
    next.piece[3][1]=2;
    next.type = 2;
  break;
  case 5:
    for (i=1;i<3;i++)
      for (j=1;j<3;j++)
	next.piece[i][j]=2;
     next.type = 3;
  break;
  case 6:
    for (i=0;i<2;i++)
      {next.piece[i][1]=2;
      next.piece[i+1][2]=2;}
    next.type = 1;
  break;
  case 7:
    for (i=0;i<2;i++)
      {next.piece[i+1][1]=2;
      next.piece[i][2]=2;}
    next.type = 1;
  break;
  }
current.x=3;
current.y=0;
}

void draw_board(int level)
{ int x,y,i;
  char tboard [10] [22];
  gotoxy(33,2);
  cprintf("%d",score);
  gotoxy(20,2);
  cprintf("%d",level);
  gotoxy(20,4);
  cprintf("%d",lines);
  gotoxy(1,1);
  for (x=0;x<10;x++)
    for (y=0;y<22;y++)
      tboard[x][y]=board[x][y];
  for (x=0;x<4;x++)
    for (y=0;y<4;y++)
      if ((current.x+x<10)&&(current.y+y<22)&&(current.piece[x][y]!=0))
	tboard[x+current.x][y+current.y]=current.piece[x][y];
i=13;
for(y=21;y>=3;y=y-2)
  {gotoxy(2,i);
  i--;
  for(x=0;x<10;x++)
    {if ((tboard[x][y]==0)&&(tboard[x][y-1]==0))
       cprintf(" ");
    else if ((tboard[x][y]!=0)&&(tboard[x][y-1]==0))
       cprintf("");
    else if ((tboard[x][y]==0)&&(tboard[x][y-1]!=0))
       cprintf("");
    else if ((tboard[x][y]!=0)&&(tboard[x][y-1]!=0))
       cprintf("");

    }
  }
}

int update(int level)
{
int temp,x,y,i,change_all=0,game_over=0,loop=1,line=0;
char tboard [10] [22];
for (x=0;x<10;x++)
  for (y=0;y<22;y++)
    tboard[x][y]=board[x][y];
for (x=0;x<4;x++)
  for (y=0;y<4;y++)
    if((current.piece[x][y]!=0)&&(current.y+y==21))
      change_all=1;
for (x=0;x<10;x++)
   if (tboard[x][0]==2)
      change_all=1;
if (change_all!=1)
  for (x=0;x<4;x++)
    for (y=0;y<4;y++)
      if ((current.x+x<10)&&(current.y+y+1<22)&&(current.piece[x][y]!=0))
	if (tboard[x+current.x][y+current.y+1]==1)
	   change_all=1;
if (change_all==1)
  {for (x=0;x<4;x++)
    for (y=0;y<4;y++)
      if ((current.x+x<10)&&(current.y+y>=0)&&(current.piece[x][y]!=0))
	tboard[x+current.x][y+current.y]=1;
   for (x=0;x<10;x++)
     for (y=0;y<22;y++)
       board[x][y] = tboard[x][y];
   nextpiece();
   disp_next();
   }
for (x=0;x<10;x++)
   for (y=0;y<3;y++)
      if (tboard[x][y]==1)
	 game_over=1;

y=21;
if ((change_all==1)&&(game_over!=1))
   while(loop)
     {
     if ((board[0][y]==1)&&(board[1][y]==1)&&(board[2][y]==1)&&(board[3][y]==1))
     if ((board[4][y]==1)&&(board[5][y]==1)&&(board[6][y]==1)&&(board[7][y]==1))
     if ((board[8][y]==1)&&(board[9][y]==1))
	{for (x=0;x<10;x++)
	   for (i=y-1;i>0;i--)
	     {board[x][i+1]=board[x][i];
	      board[x][i]=0;
	     }
	y++;
	line++;
	}
     y--;
     if (y==0)
	loop=0;
     }
if(change_all==0)
  current.y++;
temp=level+1;
if (line==1)
{ score=100*temp+score;
  play_sample(Line_Sound1, 255, 128, 1000, FALSE);
}
else if (line==2)
{ score=300*temp+score;
  play_sample(Line_Sound2, 255, 128, 1000, FALSE);
}
else if (line==3)
{ score=600*temp+score;
  play_sample(Line_Sound3, 255, 128, 1000, FALSE);
}
else if (line==4)
{ score=1200*temp+score;
  play_sample(Line_Sound4, 255, 128, 1000, FALSE);
}

lines=lines+line;
nextlines=nextlines+line;
draw_board(level);
return game_over;
}

void left(int level)
{
int x,y,can_move=1;
char tboard [10] [22];
for (x=0;x<10;x++)
   for (y=0;y<22;y++)
      tboard [x][y] = board [x][y];
for (x=0;x<4;x++)
  for (y=0;y<4;y++)
    if ((current.x+x<10)&&(current.y+y<22)&&(current.piece[x][y]))
       tboard[x+current.x][y+current.y]=current.piece[x][y];
for (y=0;y<22;y++)
   if (tboard[0][y]==2)
      can_move=0;
for (x=1;x<10;x++)
   for (y=0;y<22;y++)
	if ((tboard[x][y]==2)&&(tboard[x-1][y]==1))
	   can_move=0;
if (can_move==1)
   current.x--;
draw_board(level);
}

void right(int level)
{
int x,y,can_move=1;
char tboard [10] [22];
for (x=0;x<10;x++)
   for (y=0;y<22;y++)
      tboard [x][y] = board [x][y];
for (x=0;x<4;x++)
  for (y=0;y<4;y++)
    if ((current.x+x<10)&&(current.y+y<22)&&(current.piece[x][y]))
       tboard[x+current.x][y+current.y]=current.piece[x][y];
for (y=0;y<22;y++)
   if (tboard[9][y]==2)
      can_move=0;
for (x=0;x<9;x++)
   for (y=0;y<22;y++)
	if ((tboard[x][y]==2)&&(tboard[x+1][y]==1))
	   can_move=0;
if (can_move==1)
   current.x++;
draw_board(level);
}

void rotate_piece(int level)
{ int x,y,dir=1,can_rotate=1;
  char temp [4][4];
  for(x=0;x<4;x++)
    for(y=0;y<4;y++)
      temp[x][y] = 0;
  switch(current.type) {
    case 1:
      if (dir==1) {
	for(x=0;x<4;x++)
	  for(y=0;y<4;y++)
	    temp[y][3-x] = current.piece[x][y]; }
      else if (dir==2) {
	for(x=0;x<4;x++)
	  for(y=0;y<4;y++)
	    temp[3-y][x] = current.piece[x][y]; }
    break;
    case 2:
      if (dir==1) {
	for(x=1;x<4;x++)
	  for(y=0;y<3;y++)
	    temp[y+1][3-x] = current.piece[x][y]; }
      else if (dir==2) {
	for(x=1;x<4;x++)
	  for(y=0;y<3;y++)
	    temp[3-y][x-1] = current.piece[x][y]; }
    break;
    case 3:
    can_rotate=0;
    break;
  }
for(x=0;x<4;x++)
  for(y=0;y<4;y++)
    if (temp[x][y]!=0)
      if((x+current.x<0)||(x+current.x>9)||(y+current.y>21)||(board[x+current.x][y+current.y]!=0))
	can_rotate=0;
if (can_rotate==1)
{ for(x=0;x<4;x++)
    for(y=0;y<4;y++)
      current.piece[x][y] = temp[x][y];
  draw_board(level);
}
}
