// Darryll Sulymka
/*** Changing text version of tetris to a graphical one using DJGPP  
	And Allegro ***/
#include <stdlib.h>
#include <stdio.h>
#include "allegro.h"
/*** defines for data file ******************************************/
#define blocks                           0        /* BMP  */
#define game                             1        /* BMP  */
#define game_pal                         2        /* PAL  */
#define gameover                         3        /* SAMP */
#define line1                            4        /* SAMP */
#define line2                            5        /* SAMP */
#define line3                            6        /* SAMP */
#define line4                            7        /* SAMP */
#define song1                            8        /* MIDI */
#define song2                            9        /* MIDI */
#define song3                            10       /* MIDI */
#define song4                            11       /* MIDI */
#define song5                            12       /* MIDI */
#define song6                            13       /* MIDI */
#define song7                            14       /* MIDI */
#define song8                            15       /* MIDI */
#define song9                            16       /* MIDI */
#define title                            17       /* BMP  */
#define title_pal                        18       /* PAL  */
/*** Program Comprtion *********************************************/
BEGIN_COLOR_DEPTH_LIST
  COLOR_DEPTH_8
END_COLOR_DEPTH_LIST

BEGIN_GFX_DRIVER_LIST
  GFX_DRIVER_VGA
END_GFX_DRIVER_LIST

BEGIN_DIGI_DRIVER_LIST
 DIGI_DRIVER_SB
END_DIGI_DRIVER_LIST

BEGIN_MIDI_DRIVER_LIST
  MIDI_DRIVER_ADLIB
  MIDI_DRIVER_SB_OUT
END_MIDI_DRIVER_LIST
/*** Structs ***********************************************************/
struct piece {
	char piece[4][4],type;
	int x,y; };
/*** Globles *******************************************************/
struct piece current, next[4];
DATAFILE *tetris_data;
BITMAP *board_thing;
BITMAP *the_block;
BITMAP *title2;
BITMAP *game_background;
PALLETE title_pallete;
MIDI *the_music;
SAMPLE *That_all;
SAMPLE *Line_Sound1;
SAMPLE *Line_Sound2;
SAMPLE *Line_Sound3;
SAMPLE *Line_Sound4; 
int hiscore,song=1,score,lines,nextlines,speedfade=5;
int Cheat=0;
char board[10][22];
volatile int time_test = 0;

/*** timer interrupt handler ******************************************/
void inc_time_test()
{time_test++;}
END_OF_FUNCTION(inc_time_test);
/*** File Stuff (Hi Score) ********************************************/
short Read_Word(FILE *in) {
	return ((short)fgetc(in)<<8)+(short)fgetc(in); }

long Read_Long(FILE *in) {
       return ((long)Read_Word(in)<<16)+(long)Read_Word(in); }

void Write_Long(FILE *in, long l) {
  fputc(((l>>24)&0xff), in);
  fputc(((l>>16)&0xff), in);
  fputc(((l>>8)&0xff), in);
  fputc((l&0xff), in); }
/*** declaring functions *******************************************/
void menu();
void menu_disp(int start_level);
void music_next();
void menu_setup();
void menu_swicth(int item,int start_level);
void credits();
void game2(int level);
void nextpiece();
int update(int level);
void left(int level);
void right(int level);
void rotate_piece(int level);
void disp_setup(int level);
void draw_board(int level);
void disp_next();
/*** Functions *****************************************************/

int main()
{char *temp;
 FILE *in;
 if ((in = fopen("tetris.top", "rt")) == NULL)
   hiscore=5000;
 else
  {hiscore = Read_Long(in);
   fclose(in);
  }
 allegro_init();
 install_keyboard();
 install_timer();
 LOCK_VARIABLE(time_test);
 LOCK_FUNCTION(inc_time_test);
 install_int(inc_time_test, 50);
 tetris_data = load_datafile ("tetris.dat");
 set_gfx_mode(GFX_VGA, 320, 200, 0, 0);
 install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, temp);
 the_music = (MIDI *)tetris_data[song1].dat;
 play_midi(the_music, TRUE);
 That_all = (SAMPLE *)tetris_data[gameover].dat;
 Line_Sound1 = (SAMPLE *)tetris_data[line1].dat;
 Line_Sound2 = (SAMPLE *)tetris_data[line2].dat;
 Line_Sound3 = (SAMPLE *)tetris_data[line3].dat;
 Line_Sound4 = (SAMPLE *)tetris_data[line4].dat;
 the_block = (BITMAP *)tetris_data[blocks].dat;
 title2 = (BITMAP *)tetris_data[title].dat;
 game_background = (BITMAP *)tetris_data[game].dat;
 board_thing = create_bitmap(80, 160);
 fade_out(64);
 menu();
 allegro_exit();
 if ((in = fopen("tetris.top", "wt")) == NULL)
   fprintf(stderr, "Cannot open output file.\n");
 else
  {Write_Long(in,hiscore);
   fclose(in);
  }
 return 0;
}
void menu_setup()
{blit( title2, screen, 0,0,0,0,SCREEN_W,SCREEN_H);
fade_in(tetris_data[title_pal].dat, speedfade);
}

void menu()
{
int loop=1,item=1,start_level=0;
char level;
menu_setup();
menu_swicth(item,start_level);
while(loop)
{ if(key[KEY_1])
    Cheat=1;
  if(key[KEY_UP])
     if(item!=1)
       {item--;
       menu_swicth(item,start_level);
       while(key[KEY_UP]);}
   if(key[KEY_DOWN])
     if(item!=5)
       {item++;
       menu_swicth(item,start_level);
       while(key[KEY_DOWN]);}
   if(key[KEY_ENTER])
     {switch(item)
     {case 1: //The Game part goes here
	srand(time_test);
	fade_out(speedfade);
	game2(start_level);
	fade_out(speedfade);
	menu_setup();
	menu_swicth(item,start_level);
      break;
      case 2:
	music_next();
      break;
      case 3: //The levels
	start_level++;
	if(start_level==10)
	  start_level=0;
	menu_swicth(item,start_level);
      break;
      case 4://credits
      fade_out(speedfade);
      credits();
      menu_swicth(item,start_level);
      break;
      case 5:
      loop=0;
      break;
      }
      while(key[KEY_ENTER]);}
}
}
void menu_disp(int start_level)
{
 textprintf_centre(screen, font, SCREEN_W/2, 81, 250, "Game Menu");
 textprintf_centre(screen, font, SCREEN_W/2, 100, 251, "Play Game");
 textprintf_centre(screen, font, SCREEN_W/2, 115, 251, "Change Music");
 textprintf_centre(screen, font, SCREEN_W/2, 130, 251, "Level [%d]",start_level);
 textprintf_centre(screen, font, SCREEN_W/2, 145, 251, "Credits");
 textprintf_centre(screen, font, SCREEN_W/2, 160, 251, "Quit");
}
void menu_swicth(int item,int start_level)
{char *level;
int tcolor=252;
menu_disp(start_level);
switch(item)
       {case 1:
	 textprintf_centre(screen, font, SCREEN_W/2, 100, tcolor, "Play Game");
       break;
       case 2:
	 textprintf_centre(screen, font, SCREEN_W/2, 115, tcolor, "Change Music");
       break;
       case 3:
	textprintf_centre(screen, font, SCREEN_W/2, 130, tcolor, "Level [%d]",start_level);
       break;
       case 4:
	 textprintf_centre(screen, font, SCREEN_W/2, 145, tcolor, "Credits");
       break;
       case 5:
	textprintf_centre(screen, font, SCREEN_W/2, 160, tcolor, "Quit");
       break;}
}

void music_next()
{
switch(song)
  {
  case 1:
    stop_midi();
    the_music = (MIDI *)tetris_data[song2].dat;
    play_midi(the_music, TRUE);
    song++;
  break;
  case 2:
    stop_midi();
    the_music = (MIDI *)tetris_data[song3].dat;
    play_midi(the_music, TRUE);
    song++;
  break;
  case 3:
    stop_midi();
    the_music = (MIDI *)tetris_data[song4].dat;
    play_midi(the_music, TRUE);
    song++;
  break;
  case 4:
    stop_midi();
    the_music = (MIDI *)tetris_data[song5].dat;
    play_midi(the_music, TRUE);
    song++;
  break;
  case 5:
    stop_midi();
    the_music = (MIDI *)tetris_data[song6].dat;
    play_midi(the_music, TRUE);
    song++;
  break;
  case 6:
    stop_midi();
    the_music = (MIDI *)tetris_data[song7].dat;
    play_midi(the_music, TRUE);
    song++;
  break;
  case 7:
    stop_midi();
    the_music = (MIDI *)tetris_data[song8].dat;
    play_midi(the_music, TRUE);
    song++;
  break;
  case 8:
    stop_midi();
    the_music = (MIDI *)tetris_data[song9].dat;
    play_midi(the_music, TRUE);
    song++;
  break;
  case 9:
    stop_midi();
    the_music = (MIDI *)tetris_data[song1].dat;
    play_midi(the_music, TRUE);
    song=1;
  break;
}}
void credits()
{
menu_setup();
textprintf_centre(screen, font, SCREEN_W/2, 81, 250, "Credits");
textprintf_centre(screen, font, SCREEN_W/2, 100, 251, "Programer");
textprintf_centre(screen, font, SCREEN_W/2, 110, 252, "Darryll Sulymka");
textprintf_centre(screen, font, SCREEN_W/2, 125, 251, "Graphic");
textprintf_centre(screen, font, SCREEN_W/2, 135, 252, "Brandon Blanck");
textprintf_centre(screen, font, SCREEN_W/2, 150, 251, "Music");
textprintf_centre(screen, font, SCREEN_W/2, 160, 252, "Peter Senften");
while(!key[KEY_ESC]);
fade_out(speedfade);
menu_setup();
}
void game2(int level)
{
int i,x=time_test,key_time[7],loop=1,temp;
lines=0;nextlines=0;score=0;
for(i=0;i<7;i++)
key_time[i]=time_test;
disp_setup(level);
while(loop)
{
if (key[KEY_ESC])
  loop=0;
if((key[KEY_M])&&(key_time[5]<=time_test))
  {music_next();
  key_time[5]=time_test+8;
  }
if((key[KEY_S])&&(key_time[6]<=time_test))
  {stop_midi();
  key_time[6]=time_test+8;
  }
if(key[KEY_P])
  {while(key[KEY_P]);
  textprintf_centre(screen, font, SCREEN_W/2, 100, 251, "Pause");
  while(!key[KEY_P]);
  while(key[KEY_P]);
  draw_board(level);
  }
if ((key[KEY_RIGHT])&&(key_time[0]<=time_test))
   {right(level);
   key_time[0]=time_test+3;}
else if ((key[KEY_LEFT])&&(key_time[1]<=time_test))
   {left(level);
   key_time[1]=time_test+3;}
else if ((key[KEY_UP])&&(key_time[2]<=time_test))
   {rotate_piece(level);
   key_time[2]=time_test+4;}
else if ((key[KEY_DOWN])&&(key_time[3]<=time_test))
   {if (update(level)==1)
       loop=0;
   key_time[3]=time_test+1;}
if (x<=time_test)
 {temp=40/(level+1);
  if (update(level)==1)
    loop=0;
  if (nextlines>=10)
  {nextlines=nextlines-10;
  level++;}
  x=time_test+temp;
}}
textprintf_centre(screen, font, SCREEN_W/2, 100, 251, "Game Over");
play_sample(That_all, 255, 128, 1000, FALSE);
while(key[KEY_ESC]);
while(!key[KEY_ESC]);
if(Cheat==0)
  if(hiscore<score)
    hiscore=score;
}

void nextpiece()
{int x,y,i,j;
current=next[0];
next[0]=next[1];
next[1]=next[2];
next[2]=next[3];
for (x=0;x<4;x++)
   for (y=0;y<4;y++)
      next[3].piece[x][y]=0;
if(Cheat==1)
 {for (x=0;x<4;x++)
   next[3].piece[x][1]=2;
  next[3].type = 1;
  }
else
 switch (rand()%7+1)
  {case 1:     //line
    for (x=0;x<4;x++)
      next[3].piece[x][1]=2;
    next[3].type = 1;
  break;
  case 2:       //L
    for (x=1;x<4;x++)
      next[3].piece[x][2]=3;
    next[3].piece[1][1]=3;
    next[3].type = 2;
  break;
  case 3:
    for (x=1;x<4;x++)
      next[3].piece[x][2]=4;
    next[3].piece[2][1]=4;
    next[3].type = 2;
  break;
  case 4:
    for (x=1;x<4;x++)
      next[3].piece[x][2]=5;
    next[3].piece[3][1]=5;
    next[3].type = 2;
  break;
  case 5:
    for (i=1;i<3;i++)
      for (j=1;j<3;j++)
	next[3].piece[i][j]=6;
     next[3].type = 3;
  break;
  case 6:
    for (i=0;i<2;i++)
      {next[3].piece[i][1]=7;
      next[3].piece[i+1][2]=7;}
    next[3].type = 1;
  break;
  case 7:
    for (i=0;i<2;i++)
      {next[3].piece[i+1][1]=8;
      next[3].piece[i][2]=8;}
    next[3].type = 1;
  break;
  }

current.x=3;
current.y=0;
}
int update(int level)
{
int temp,x,y,i,change_all=0,game_over=0,loop=1,line=0;
char tboard [10] [22];
for (x=0;x<10;x++)
  for (y=0;y<22;y++)
    tboard[x][y]=board[x][y];
for (x=0;x<4;x++)
  for (y=0;y<4;y++)
    if((current.piece[x][y]!=0)&&(current.y+y==21))
      change_all=1;
if (change_all!=1)
  for (x=0;x<4;x++)
    for (y=0;y<4;y++)
      if ((current.x+x<10)&&(current.y+y+1<22)&&(current.piece[x][y]!=0))
	if (tboard[x+current.x][y+current.y+1]!=0)
	   change_all=1;
if (change_all==1)
  {for (x=0;x<4;x++)
    for (y=0;y<4;y++)
      if ((current.x+x<10)&&(current.y+y>=0)&&(current.piece[x][y]!=0))
	tboard[x+current.x][y+current.y]=current.piece[x][y];
   for (x=0;x<10;x++)
     for (y=0;y<22;y++)
       board[x][y] = tboard[x][y];
   nextpiece();
   disp_next();
   }
for (x=0;x<10;x++)
   for (y=0;y<3;y++)
      if (tboard[x][y]!=0)
	 game_over=1;

y=21;
if ((change_all==1)&&(game_over!=1))
   while(loop)
     {
     if ((board[0][y]!=0)&&(board[1][y]!=0)&&(board[2][y]!=0)&&(board[3][y]!=0))
     if ((board[4][y]!=0)&&(board[5][y]!=0)&&(board[6][y]!=0)&&(board[7][y]!=0))
     if ((board[8][y]!=0)&&(board[9][y]!=0))
	{for (x=0;x<10;x++)
	   for (i=y-1;i>0;i--)
	     {board[x][i+1]=board[x][i];
	      board[x][i]=0;
	     }
	y++;
	line++;
	}
     y--;
     if (y==0)
	loop=0;
     }
if(change_all==0)
  current.y++;
temp=level+1;
if (line==1)
{ score=100*temp+score;
  play_sample(Line_Sound1, 255, 128, 1000, FALSE);
}
else if (line==2)
{ score=300*temp+score;
  play_sample(Line_Sound2, 255, 128, 1000, FALSE);
}
else if (line==3)
{ score=600*temp+score;
  play_sample(Line_Sound3, 255, 128, 1000, FALSE);
}
else if (line==4)
{ score=1200*temp+score;
  play_sample(Line_Sound4, 255, 128, 1000, FALSE);
}

lines=lines+line;
nextlines=nextlines+line;
draw_board(level);
return game_over;
}

void left(int level)
{
int x,y,can_move=1;
char tboard [10] [22];
for (x=0;x<10;x++)
   for (y=0;y<22;y++)
      tboard [x][y] = board [x][y];
for (x=0;x<4;x++)
  for (y=0;y<4;y++)
    if ((current.x+x<10)&&(current.y+y<22)&&(current.piece[x][y]))
       tboard[x+current.x][y+current.y]=1;
for (y=0;y<22;y++)
   if (tboard[0][y]==1)
      can_move=0;
for (x=1;x<10;x++)
   for (y=0;y<22;y++)
	if ((tboard[x][y]==1)&&(tboard[x-1][y]>1))
	   can_move=0;
if (can_move==1)
   current.x--;
draw_board(level);
}

void right(int level)
{
int x,y,can_move=1;
char tboard [10] [22];
for (x=0;x<10;x++)
   for (y=0;y<22;y++)
      tboard [x][y] = board [x][y];
for (x=0;x<4;x++)
  for (y=0;y<4;y++)
    if ((current.x+x<10)&&(current.y+y<22)&&(current.piece[x][y]))
       tboard[x+current.x][y+current.y]=1;
for (y=0;y<22;y++)
   if (tboard[9][y]==1)
      can_move=0;
for (x=0;x<9;x++)
   for (y=0;y<22;y++)
	if ((tboard[x][y]==1)&&(tboard[x+1][y]>1))
	   can_move=0;
if (can_move==1)
   current.x++;
draw_board(level);
}
void rotate_piece(int level)
{ int x,y,dir=1,can_rotate=1;
  char temp [4][4];
  for(x=0;x<4;x++)
    for(y=0;y<4;y++)
      temp[x][y] = 0;
  switch(current.type) {
    case 1:
      if (dir==1) {
	for(x=0;x<4;x++)
	  for(y=0;y<4;y++)
	    temp[y][3-x] = current.piece[x][y]; }
      else if (dir==2) {
	for(x=0;x<4;x++)
	  for(y=0;y<4;y++)
	    temp[3-y][x] = current.piece[x][y]; }
    break;
    case 2:
      if (dir==1) {
	for(x=1;x<4;x++)
	  for(y=0;y<3;y++)
	    temp[y+1][3-x] = current.piece[x][y]; }
      else if (dir==2) {
	for(x=1;x<4;x++)
	  for(y=0;y<3;y++)
	    temp[3-y][x-1] = current.piece[x][y]; }
    break;
    case 3:
    can_rotate=0;
    break;
  }
for(x=0;x<4;x++)
  for(y=0;y<4;y++)
    if (temp[x][y]!=0)
      if((x+current.x<0)||(x+current.x>9)||(y+current.y>21)||(board[x+current.x][y+current.y]!=0))
	can_rotate=0;
if (can_rotate==1)
{ for(x=0;x<4;x++)
    for(y=0;y<4;y++)
      current.piece[x][y] = temp[x][y];
  draw_board(level);
}
}
void disp_setup(int level)
{int x,y;
blit(game_background, screen, 0,0,0,0,SCREEN_W,SCREEN_H);
fade_in(tetris_data[game_pal].dat, speedfade);
for (x=0;x<10;x++)
   for (y=0;y<22;y++)
      board [x][y] = 0;
for (x=0;x<5;x++)
  nextpiece();
disp_next();
draw_board(level);
}
void draw_board(int level)
{ int x,y,i;
  char tboard [10] [22];
  textprintf(screen, font, 212, 34, 250, "%d",score);
  textprintf(screen, font, 254, 53, 250, "%d",lines);
  textprintf(screen, font, 250, 71, 250, "%d",level);
  textprintf(screen, font, 159, 184, 250, "%d",hiscore);
  for (x=0;x<10;x++)
    for (y=0;y<22;y++)
      tboard[x][y]=board[x][y];
  for (x=0;x<4;x++)
    for (y=0;y<4;y++)
      if ((current.x+x<10)&&(current.y+y<22)&&(current.piece[x][y]!=0))
	tboard[x+current.x][y+current.y]=current.piece[x][y];
clear(board_thing);
for(y=19;y>=0;y--)
  {for(x=0;x<10;x++)
    {if (tboard[x][y+2]!=0)
      {i=tboard[x][y+2]-2;
      blit(the_block,board_thing,8*i,0,x*8,y*8,8,8);}
    }
  }
blit(board_thing,screen,0,0,120,20,80,160);
}

void disp_next()
{
int x,i,j;
BITMAP *temp = create_bitmap(32,70);
clear(temp);
for(j=0;j<4;j++)
  for(x=0;x<4;x++)
   {if (next[j].piece[x][2]!=0)
     {i=next[j].piece[x][2]-2;
     blit(the_block,temp,8*i,0,x*8,18*j+8,8,8);}
   if (next[j].piece[x][1]!=0)
     {i=next[j].piece[x][1]-2;
     blit(the_block,temp,8*i,0,x*8,18*j+0,8,8);}
    }
blit(temp,screen,0,0,30,36,32,72);
destroy_bitmap(temp);
}
