// Starfield

/*** Includes *******************************************************/
#include <stdlib.h>
#include "allegro.h"
#include "creadits.h"
#include "pal.h"          //Data file with paletes
#include "space.h"        //All Images in this on
#include "font.h"        // The neet font
#include "sndm.h"       //Music And Sounds

/*** defines and data file stuff **************************************/
#define ScreenWidth  320
#define ScreenHeight 200
#define ScreenDist   64000
#define MaxZpos      4096
#define MinZpos      2
#define MaxStars     40
#define NumColors    5
#define Fade_Speed   15
/*** Program Comprtion *********************************************/
BEGIN_COLOR_DEPTH_LIST
  COLOR_DEPTH_8
END_COLOR_DEPTH_LIST

BEGIN_GFX_DRIVER_LIST
  GFX_DRIVER_VGA
END_GFX_DRIVER_LIST

/*** Structs ***********************************************************/
struct Star_Struc
{int  X,Y,Z;
 char Color;
};
struct zing
{
int x;
int y;
int act;
};
struct invator
{
int act;
};
/*** Timer Stuff *******************************************************/
volatile int time_test=0; // globle timer
volatile int The_bb=0;    // The shots timer
volatile int time_inv=0;  // invators time varable
volatile int inv_anim=0;  // invators animation
volatile int inv_stoot_time=0;
void inc_time_test()
{time_test++;The_bb++;time_inv++;inv_anim++;inv_stoot_time++;}
END_OF_FUNCTION(inc_time_test);
/*** Globle ************************************************************/
BITMAP *The_Buffer;             // Screen Buffer
BITMAP *The_Image;              // Title Image
BITMAP *game_bar;
BITMAP *The_ship;
BITMAP *A1_1;  BITMAP *A1_2;    // Alien Type One
BITMAP *A2_1;  BITMAP *A2_2;    // Alien Type Two
BITMAP *A3_1;  BITMAP *A3_2;    // Alien Type Three
BITMAP *Blocker;
BITMAP *Blocker_1;BITMAP *Blocker_2;
BITMAP *Blocker_3;BITMAP *Blocker_4;
BITMAP *The_Great_Darryll;
DATAFILE *pal_data;
DATAFILE *sandm_data;
struct Star_Struc stars[41];    // Star for starfield
struct zing shoot;              // Player wepoin
struct zing inv_shoot[10];
struct invator invators[5][12]; // The Aliens
int cheats_active = 0;
/*** Functions *********************************************************/
void Start_Game();                     // The game
int program_ini();                     // Program startup
void star_field();                     // Think
void draw_invators(int x,int y,int phase); // think
int Put_Shoot(int x,int y);            // Think
int font_fading(int ypos);             // The credits
void texttt(int text_h,int no_lines);  // other part of credits
void inv_update(int &x, int &y, int &direction,int how_many,int x1,int x2);
void draw_blockers();
int Left_check();
int Right_check();
void make_inv_shot(int x1,int y);
int find_free();
int draw_inv_shot(int x,int y);

/*** The Code **********************************************************/
int main()
{int c, i, on_off=0,no_lines=0, text_h, loop=1;
 program_ini();
 text_h = text_height (font);
 for (i=0; credits[i][0];i++)  // count no of lines in credits array
   no_lines++;

while(!key[KEY_ESC])
 {if(key[KEY_SPACE])
   {Start_Game();
   fade_in((PALLETE)pal_data[Title_Pal].dat, Fade_Speed);
   }
   if((key[KEY_G])&&(key[KEY_CONTROL]))
     cheats_active = 1;
   if((key[KEY_O])&&(key[KEY_CONTROL]))
    {if(cheats_active >= 1)
      cheats_active = 2;
     else
      cheats_active = 0;
     }
   if((key[KEY_D])&&(key[KEY_CONTROL]))
    {if(cheats_active >= 2)
      cheats_active = 3;
     else
      cheats_active = 0;
     }

  clear(The_Buffer);
  blit(The_Image, The_Buffer, 0, 0, 79,0, 160, 100);
  star_field();
  if(inv_anim>8)
   {if(on_off==1)
     {on_off=0;inv_anim=0;}
   else
    {on_off=1;inv_anim=0;}
   }
  if(cheats_active==3)
    textprintf(The_Buffer, font, 236, 190, 242,"Cheats Enabled");
  if(on_off)
   {textprintf_centre(The_Buffer, font, 159, 170, 242,"Press <Space> to Begin");
   textprintf_centre(The_Buffer, font, 159, 180, 242,"<ESC> to quit");
   }
  blit( The_Buffer, screen, 0,0,0,0,SCREEN_W,SCREEN_H);
 }

while(key[KEY_ESC]);
time_test = 0;
play_midi((MIDI *)sandm_data[endmusic].dat , TRUE);
loop=1;
while(loop)
 {clear(The_Buffer);
  star_field();
  texttt(text_h, no_lines);
  blit( The_Buffer, screen, 0,0,0,0,SCREEN_W,SCREEN_H);
  if(key[KEY_ESC])
    loop=0;
  if(time_test>1455)
    loop=0;
 }
fade_out(Fade_Speed);
blit(The_Great_Darryll, The_Buffer, 0, 0, (SCREEN_W-The_Great_Darryll->w)/2,
		     (SCREEN_H-The_Great_Darryll->h)/2, The_Great_Darryll->w, The_Great_Darryll->h);
blit( The_Buffer, screen, 0,0,0,0,SCREEN_W,SCREEN_H);
fade_in((PALLETE)pal_data[Darryll_Pal].dat, Fade_Speed);

while(key[KEY_ESC]);
while(!key[KEY_ESC]);
fade_out(Fade_Speed);
allegro_exit();
return 0;
}
int program_ini()
{int temp;
 char *Temp;
 DATAFILE *text_data;
 DATAFILE *Pic_data;
 srand(4584);
 for(temp=0;temp<40;temp++)
 {stars[temp].X=rand()%30+1;
  stars[temp].Y=rand()%20+1;
  stars[temp].Z=rand()%MaxZpos+1;
 }
 allegro_init();
 install_keyboard();
 install_timer();
 LOCK_VARIABLE(time_test);
 LOCK_VARIABLE(The_bb);
 LOCK_VARIABLE(time_inv);
 LOCK_VARIABLE(inv_anim);
 LOCK_FUNCTION(inc_time_test);
 install_int(inc_time_test, 30);
 set_gfx_mode(GFX_VGA, 320, 200, 0, 0);
 install_mouse();
 install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, Temp);
 The_Buffer = create_bitmap(320, 200);
 text_data = load_datafile ("font.dat");
 pal_data = load_datafile ("pal.dat");
 Pic_data = load_datafile ("Space.dat");
 sandm_data = load_datafile ("sandm.dat");
 font=(FONT *)text_data[neet].dat;
 A1_1 = create_bitmap(12, 8);
 blit( (BITMAP *)Pic_data[Alien1_1].dat, A1_1, 0,0,0,0,A1_1->w,A1_1->h);
 A1_2 = create_bitmap(12, 8);
 blit( (BITMAP *)Pic_data[Alien1_2].dat, A1_2, 0,0,0,0,A1_2->w,A1_2->h);
 A2_1 = create_bitmap(11, 9);
 blit( (BITMAP *)Pic_data[Alien2_1].dat, A2_1, 0,0,0,0,A2_1->w,A2_1->h);
 A2_2 = create_bitmap(11, 9);
 blit( (BITMAP *)Pic_data[Alien2_2].dat, A2_2, 0,0,0,0,A2_2->w,A2_2->h);
 A3_1 = create_bitmap(12, 9);
 blit( (BITMAP *)Pic_data[Alien3_1].dat, A3_1, 0,0,0,0,A3_1->w,A3_1->h);
 A3_2 = create_bitmap(12, 9);
 blit( (BITMAP *)Pic_data[Alien3_2].dat, A3_2, 0,0,0,0,A3_2->w,A3_2->h);
 The_Image = create_bitmap(160, 100);
 blit( (BITMAP *)Pic_data[Title_Pic].dat, The_Image, 0,0,0,0,The_Image->w,The_Image->h);
 game_bar = create_bitmap(320, 30);
 blit( (BITMAP *)Pic_data[Game_Bar].dat, game_bar, 0,0,0,0,game_bar->w,game_bar->h);
 The_ship = create_bitmap(13, 8);
 blit( (BITMAP *)Pic_data[Neet_Ship].dat, The_ship, 0,0,0,0,The_ship->w,The_ship->h);
 set_pallete((PALLETE)pal_data[Title_Pal].dat);
 The_Great_Darryll = create_bitmap(266, 200);
 blit( (BITMAP *)Pic_data[Darryll_Creidits].dat, The_Great_Darryll, 0,0,0,0,The_Great_Darryll->w,The_Great_Darryll->h);
 Blocker = create_bitmap(24, 16);
 blit( (BITMAP *)Pic_data[Blocker_pic].dat, Blocker, 0,0,0,0,Blocker->w,Blocker->h);
 Blocker_1 = create_bitmap(24, 16);
 Blocker_2 = create_bitmap(24, 16);
 Blocker_3 = create_bitmap(24, 16);
 Blocker_4 = create_bitmap(24, 16);
 return 0;
}

void star_field()
{int x,y,color;
 int temp,numstars=MaxStars;
 for(temp=0;temp<MaxStars;temp++)
   if(stars[temp].Z!=0)
    stars[temp].Z=stars[temp].Z-10;
  for(temp=0;temp<MaxStars;temp++)
  {x=ScreenDist*stars[temp].X/stars[temp].Z;
   y=ScreenDist*stars[temp].Y/stars[temp].Z;
   color=stars[temp].Z/64;
   if((x<SCREEN_W)&&(y<SCREEN_H))
      putpixel(The_Buffer, x, y, 64-color);
   else
    {stars[temp].Z=0;
    numstars--;
    }
  }
  temp=0;
  while(numstars!=MaxStars)
  {if(stars[temp].Z==0)
   {stars[temp].X=rand()%30+1;
    stars[temp].Y=rand()%20+1;
    stars[temp].Z=MaxZpos;
    numstars++;
   }
   temp++;
   }
}

void Start_Game()
{int loop=1,direction=0,score=0,phase=0,inv_num_tot=0,level=0,attack;
 int i,x,y,x1,x2,calcx,calcy,lives=3;
 PALLETE pallete;
 if(key[KEY_L])
  if(cheats_active==3)
    lives=100;
 while(key[KEY_SPACE]);
 position_mouse(SCREEN_W/2, 182);
 set_mouse_range(0, 180, SCREEN_W-13, 185);
 fade_out(Fade_Speed);
 while(loop==1)
  {if(inv_num_tot==0)
    {level++;
     for(x=0;x<5;x++)
       for(y=0;y<12;y++)
         invators[x][y].act=1;
     for(i=0;i<10;i++)
       inv_shoot[i].act = 0;
     clear(The_Buffer);
     blit(game_bar, The_Buffer, 0,0,0,0,game_bar->w,game_bar->h);
     textprintf(The_Buffer, font, 28, 19, 3, "%d",score);
     textprintf_centre(The_Buffer, font, 160, 100, 3,"Level %d",level);
     textprintf(The_Buffer, font, 290, 19, 3, "%d",lives);
     for(i=0;i<193;i=i+64)
     blit(Blocker, The_Buffer, 0,0,52+i,155,Blocker->w,Blocker->h);
     blit( The_Buffer, screen, 0,0,0,0,SCREEN_W,SCREEN_H);
     play_sample((SAMPLE *)sandm_data[next_level].dat , 255, 128, 1000, FALSE);
     fade_in((PALLETE)pal_data[Game_Pal].dat, Fade_Speed);
     attack=60/level;x1=Left_check();x2=Right_check();
     rest(3000);
     shoot.act=0;time_inv=0;inv_anim=0;x=0;y=50;inv_num_tot=60;
    }
  clear(The_Buffer);
  if(key[KEY_P])
   {remove_int(inc_time_test);
    textprintf_centre(The_Buffer, font, 160, 100, 3,"Pause");
    textprintf_centre(screen, font, 160, 100, 3,"Pause");
    while(key[KEY_P]);
    while(!key[KEY_P]);
    while(key[KEY_P]);
    install_int(inc_time_test, 30);
   }
  if(mouse_b)
   if(shoot.act==0)
    {shoot.act=1;
     shoot.x=mouse_x+6;
     shoot.y=177;
     The_bb=0;
     play_sample((SAMPLE *)sandm_data[fire].dat, 255, 128, 1000, FALSE);
    }
  if(inv_anim>7)
   if(phase==0)
    {inv_anim=0;
     phase=1;
     play_sample((SAMPLE *)sandm_data[linv].dat, 255, 128, 1000, FALSE);
    }
   else if(phase==1)
    {inv_anim=0;
     phase=0;
     play_sample((SAMPLE *)sandm_data[rinv].dat, 255, 128, 1000, FALSE);
    }
   inv_update(x,y,direction,inv_num_tot,x1,x2);
   draw_blockers();
   draw_invators(x,y,phase);
   blit(The_ship, The_Buffer, 0,0,mouse_x,180,The_ship->w,The_ship->h);
   if(inv_stoot_time>attack)
     make_inv_shot(x,y);
   if (key[KEY_SPACE])
     if(cheats_active==3)
        shoot.x=mouse_x+6;
   for(i=0;i<10;i++)
     if(inv_shoot[i].act==1)
       inv_shoot[i].y+=The_bb*2;
   if (shoot.act)
   {shoot.y=shoot.y-The_bb*3;
    The_bb=0;
   shoot.act=Put_Shoot(shoot.x,shoot.y);
    }
  if(!shoot.act)
   The_bb=0;
  if (shoot.act==2)
   {shoot.act=0;
   calcx=((shoot.x+15-x)/15)-1;
   calcy=((shoot.y+15-y)/15)-1;
   if((calcx>=0)&&(calcx<12))
    if((calcy>=0)&&(calcy<5))
     {if(invators[calcy][calcx].act==1)
      {inv_num_tot--;
       invators[calcy][calcx].act=0;
       play_sample((SAMPLE *)sandm_data[dead_alien].dat, 255, 128, 1000, FALSE);
       x1=Left_check();x2=Right_check();
       score+=(5-calcy)*5;
     }}
   }
   for(i=0;i<10;i++)
     if(inv_shoot[i].act==1)
        inv_shoot[i].act=draw_inv_shot(inv_shoot[i].x,inv_shoot[i].y);
   for(i=0;i<10;i++)
     if(inv_shoot[i].act==7)
      {lives--;
       play_sample((SAMPLE *)sandm_data[loose_a_life].dat, 255, 128, 1000, FALSE);
       for(i=0;i<10;i++)
         inv_shoot[i].act=0;
       break;
       }
     else if(inv_shoot[i].act>1)
       inv_shoot[i].act=0;
  blit(game_bar, The_Buffer, 0,0,0,0,game_bar->w,game_bar->h);
  textprintf(The_Buffer, font, 28, 19, 3, "%d",score);
  textprintf(The_Buffer, font, 290, 19, 3, "%d",lives);
  blit(The_Buffer, screen, 0,0,0,0,SCREEN_W,SCREEN_H);
  if(key[KEY_ESC])
   loop=0;
  if(lives<=0)
   loop=2;
}
if(loop==2)
 {  clear(The_Buffer);
  blit(game_bar, The_Buffer, 0,0,0,0,game_bar->w,game_bar->h);
  textprintf(The_Buffer, font, 28, 19, 3, "%d",score);
  textprintf(The_Buffer, font, 290, 19, 3, "%d",lives);
  blit(The_Buffer, screen, 0,0,0,0,SCREEN_W,SCREEN_H);
  textprintf_centre(screen, font, 160, 100, 3,"Game Over");
  textprintf_centre(screen, font, 160, 110, 3,"Your Score <%d>",score);
  textprintf_centre(screen, font, 160, 120, 3,"Press <ESC> to Go Back");
  play_sample((SAMPLE *)sandm_data[You_loose].dat, 255, 128, 1000, FALSE);
  while(!key[KEY_ESC]);
 }
while(key[KEY_ESC]);
fade_out(Fade_Speed);
}
int Put_Shoot(int x,int y)
{
if(getpixel(The_Buffer,x, y)!=0)
  {putpixel(The_Buffer,x, y, 0);
  putpixel(The_Buffer,x, y+1, 0);
  putpixel(The_Buffer,x, y+2, 0);
  return 2;}
if(getpixel(The_Buffer,x, y+1)!=0)
  {putpixel(The_Buffer,x, y, 0);
  putpixel(The_Buffer,x, y+1, 0);
  putpixel(The_Buffer,x, y+2, 0);
  return 2;}
if(getpixel(The_Buffer,x, y+2)!=0)
  {putpixel(The_Buffer,x, y, 0);
  putpixel(The_Buffer,x, y+1, 0);
  putpixel(The_Buffer,x, y+2, 0);
  return 2;}
if(y>20)
 {putpixel(The_Buffer,x, y, 15);
  putpixel(The_Buffer,x, y+1, 15);
  putpixel(The_Buffer,x, y+2, 15);
 }
else
 return 0;
return 1;
}

void texttt(int text_h,int no_lines)
{ int color,i,ypos;
  ypos = 160 - (time_test / 3);
  if (ypos < ( 100-(text_h/2) - (text_h*(no_lines+2))+5) )
     ypos = ( 100-(text_h/2) - (text_h*(no_lines+2))+5);
  for (i=0; i < no_lines;i++)
   {color = font_fading(ypos + (text_h * i));
    textout_centre(The_Buffer,font,credits[i], 160, ypos+(text_h*i), color);
   }
}
int font_fading(int ypos)
{   if (ypos <= 100)
        return ((ypos * 53) / 100) + 10;
    else if (ypos >= (The_Buffer->h - 120) &&  ypos < (The_Buffer->h - 20) )
        return (ABS(ypos - The_Buffer->h+20) * 63 / 100) + 0;
    else if (ypos >= (The_Buffer->h - 20))
        return 0;
    return 63;
}

void draw_invators(int x,int y,int phase)
{int i;
if(phase==0)
{for(i=0;i<12;i++)
  if (invators[0][i].act==1)
   blit(A1_1, The_Buffer, 0, 0,i*15+x,y, A1_1->w, A1_1->h);
 for(i=0;i<12;i++)
  if (invators[1][i].act==1)
   blit(A2_1, The_Buffer, 0, 0,i*15+x,15+y, A2_1->w, A2_1->h);
 for(i=0;i<12;i++)
  if (invators[2][i].act==1)
   blit(A2_1, The_Buffer, 0, 0,i*15+x,30+y, A2_1->w, A2_1->h);
 for(i=0;i<12;i++)
  if (invators[3][i].act==1)
   blit(A3_1, The_Buffer, 0, 0,i*15+x,45+y, A3_1->w, A3_1->h);
 for(i=0;i<12;i++)
  if (invators[4][i].act==1)
   blit(A3_1, The_Buffer, 0, 0,i*15+x,60+y, A3_1->w, A3_1->h);
 }
else
{for(i=0;i<12;i++)
 if (invators[0][i].act==1)
   blit(A1_2, The_Buffer, 0, 0,i*15+x,y, A1_2->w, A1_2->h);
 for(i=0;i<12;i++)
  if (invators[1][i].act==1)
   blit(A2_2, The_Buffer, 0, 0,i*15+x,15+y, A2_2->w, A2_2->h);
 for(i=0;i<12;i++)
  if (invators[2][i].act==1)
   blit(A2_2, The_Buffer, 0, 0,i*15+x,30+y, A2_2->w, A2_2->h);
 for(i=0;i<12;i++)
  if (invators[3][i].act==1)
   blit(A3_2, The_Buffer, 0, 0,i*15+x,45+y, A3_2->w, A3_2->h);
 for(i=0;i<12;i++)
  if (invators[4][i].act==1)
   blit(A3_2, The_Buffer, 0, 0,i*15+x,60+y, A3_2->w, A3_2->h);
}
}

void inv_update(int &x, int &y, int &direction,int how_many,int x1,int x2)
{int i,over_amount=0;
if(time_inv>=2)
{over_amount=60/how_many*(time_inv-1);
 if(over_amount>3)
  over_amount=3;
 if(direction==0)
  {x=x+over_amount;time_inv=0;
   if(x>x2)
    {direction=1; y+=5; x=x2;}  }
 else if (direction==1)
 {x=x-over_amount; time_inv=0;
 if(x<x1)
  {direction=0; y+=5; x=x1;} } }
}
void draw_blockers()
{
int x,y;
blit(screen, Blocker_1, 52,155,0,0,Blocker_1->w,Blocker_1->h);
blit(screen, Blocker_2, 116,155,0,0,Blocker_2->w,Blocker_2->h);
blit(screen, Blocker_3, 180,155,0,0,Blocker_3->w,Blocker_3->h);
blit(screen, Blocker_4, 244,155,0,0,Blocker_4->w,Blocker_4->h);
for(x=0;x<=Blocker_1->w;x++)
 for(y=0;y<=Blocker_1->h;y++)
  {if(getpixel(Blocker_1,x, y)!=9)
    putpixel(Blocker_1,x, y, 0);
   if(getpixel(Blocker_2,x, y)!=9)
    putpixel(Blocker_2,x, y, 0);
   if(getpixel(Blocker_3,x, y)!=9)
    putpixel(Blocker_3,x, y, 0);
   if(getpixel(Blocker_4,x, y)!=9)
    putpixel(Blocker_4,x, y, 0);
   }
blit(Blocker_1, The_Buffer, 0,0,52,155,Blocker_1->w,Blocker_1->h);
blit(Blocker_2, The_Buffer, 0,0,116,155,Blocker_2->w,Blocker_2->h);
blit(Blocker_3, The_Buffer, 0,0,180,155,Blocker_3->w,Blocker_3->h);
blit(Blocker_4, The_Buffer, 0,0,244,155,Blocker_4->w,Blocker_4->h);
}

int Left_check()
{
int i,j;
for(j=0;j<12;j++)
 for(i=0;i<5;i++)
  if (invators[i][j].act==1)
   return -15*j;
}

int Right_check()
{
int i,j;
for(j=0;j<12;j++)
 for(i=0;i<5;i++)
  if (invators[i][11-j].act==1)
   return 143+15*j;
}

void make_inv_shot(int x1,int y)
{
int the_index,x,i,j;
 /* Calculate Human X */
for(i=0;i<12;i++)
 {x=i*15+x1-mouse_x+6;
  if((x<11)&&(x>-5))
   {for(j=4;j>=0;j--)      /* Alien Alive? */
     if(invators[j][i].act==1)
       {the_index = find_free(); /* find first avable slot */
        if(the_index!=-1)
         {inv_shoot[the_index].act=1; /* The activation of new shot */
          inv_shoot[the_index].x=15*i+x1+6;
          inv_shoot[the_index].y=j*15+y+10;
          inv_stoot_time=0;
          break;
         }
        }
  }
}

}

int find_free()
{
int i;
for(i=0;i<10;i++)
  if((inv_shoot[i].act == 0)||(inv_shoot[i].act == -1))
    return i;
return -1;
}

int draw_inv_shot(int x,int y)
{int did_it_hit;
 did_it_hit=getpixel(The_Buffer,x, y);
 if(did_it_hit!=0)
  {putpixel(The_Buffer,x, y, 0);
   putpixel(The_Buffer,x, y+1, 0);
   putpixel(The_Buffer,x, y+2, 0);
   return did_it_hit;}
 did_it_hit=getpixel(The_Buffer,x, y+1);
 if(did_it_hit!=0)
  {putpixel(The_Buffer,x, y, 0);
   putpixel(The_Buffer,x, y+1, 0);
   putpixel(The_Buffer,x, y+2, 0);
   return did_it_hit;}
 did_it_hit=getpixel(The_Buffer,x, y+2);
 if(did_it_hit!=0)
  {putpixel(The_Buffer,x, y, 0);
   putpixel(The_Buffer,x, y+1, 0);
   putpixel(The_Buffer,x, y+2, 0);
   return did_it_hit;}

 if(y>196)
   return 0;
putpixel(The_Buffer,x, y, 15);
putpixel(The_Buffer,x, y+1, 15);
putpixel(The_Buffer,x, y+2, 15);
return 1;
}
